//
//  ViewController.m
//  lSiri
//
//  Created by 黄良亮 on 12-1-30.
//  Copyright (c) 2012年 __MyCompanyName__. All rights reserved.
//

#import "ViewController.h"
#import "Config.h"

const unsigned char SpeechKitApplicationKey[] = {0xeb, 0x27, 0xc3, 0x2a, 0xa2, 0xfb, 0xf8, 0x0b, 0x32, 0x33, 0x77, 0xb0, 0xd7, 0x06, 0x05, 0xfd, 0xa1, 0xc5, 0xd5, 0x35, 0x00, 0xf3, 0x70, 0xd4, 0x72, 0xdd, 0x73, 0xf9, 0x55, 0xa7, 0x12, 0x40, 0xce, 0xd6, 0x6a, 0x71, 0xd1, 0x63, 0x7c, 0x03, 0x96, 0xf3, 0xb4, 0x6d, 0xfa, 0xb9, 0x6b, 0x9b, 0x7e, 0x40, 0xd1, 0x7f, 0x33, 0x41, 0x53, 0xa5, 0x1e, 0xc6, 0x9f, 0x73, 0x6e, 0xb1, 0xb4, 0x3c};

NSString *NuanceID = @"NMDPTRIAL_could_hll20120130005039";
NSString *NuancePassword = @"sandbox.nmdp.nuancemobility.net";

NSString *TrueKnowledgeID = @"api_couldhll";
NSString *TrueKnowledgePassword = @"1n7jh4an97r8axry";

@implementation ViewController

@synthesize recordButton,histroyTableView,voiceSearch,vocalizer,histroys;

- (void)didReceiveMemoryWarning
{
    [super didReceiveMemoryWarning];
    // Release any cached data, images, etc that aren't in use.
}

#pragma mark - View lifecycle

- (void)viewDidLoad
{
    [super viewDidLoad];
	// Do any additional setup after loading the view, typically from a nib.
    
    histroys=[[NSMutableArray alloc] init];
    
    [SpeechKit setupWithID:NuanceID
                      host:NuancePassword
                      port:443
                    useSSL:NO
                  delegate:nil];
    
	// Set earcons to play
	SKEarcon* earconStart	= [SKEarcon earconWithName:@"earcon_listening.wav"];
	SKEarcon* earconStop	= [SKEarcon earconWithName:@"earcon_done_listening.wav"];
	SKEarcon* earconCancel	= [SKEarcon earconWithName:@"earcon_cancel.wav"];
	
	[SpeechKit setEarcon:earconStart forType:SKStartRecordingEarconType];
	[SpeechKit setEarcon:earconStop forType:SKStopRecordingEarconType];
	[SpeechKit setEarcon:earconCancel forType:SKCancelRecordingEarconType];
    
    [self addTalk:@"aaa" isSelf:YES];
    
}

- (void)viewDidUnload
{
    [super viewDidUnload];
    // Release any retained subviews of the main view.
    // e.g. self.myOutlet = nil;
}

- (void)viewWillAppear:(BOOL)animated
{
    [super viewWillAppear:animated];
}

- (void)viewDidAppear:(BOOL)animated
{
    [super viewDidAppear:animated];
}

- (void)viewWillDisappear:(BOOL)animated
{
	[super viewWillDisappear:animated];
}

- (void)viewDidDisappear:(BOOL)animated
{
	[super viewDidDisappear:animated];
}

- (BOOL)shouldAutorotateToInterfaceOrientation:(UIInterfaceOrientation)interfaceOrientation
{
    // Return YES for supported orientations
    if ([[UIDevice currentDevice] userInterfaceIdiom] == UIUserInterfaceIdiomPhone) {
        return (interfaceOrientation != UIInterfaceOrientationPortraitUpsideDown);
    } else {
        return YES;
    }
}

#pragma mark -
#pragma mark Actions

- (IBAction)recordButtonAction: (id)sender
{
    if (transactionState == TS_RECORDING)
    {
        [voiceSearch stopRecording];
    }
    else if (transactionState == TS_IDLE)
    {
        SKEndOfSpeechDetection detectionType;
        NSString* recoType;
        NSString* langType;
        
        transactionState = TS_INITIAL;
        
        /* 'Search' is selected */
        detectionType = SKShortEndOfSpeechDetection; /* Searches tend to be short utterances free of pauses. */
        recoType = SKSearchRecognizerType; /* Optimize recognition performance for search text. */
        
//        /* 'Dictation' is selected */
//        detectionType = SKLongEndOfSpeechDetection; /* Dictations tend to be long utterances that may include short pauses. */
//        recoType = SKDictationRecognizerType; /* Optimize recognition performance for dictation or message text. */
		
//        langType = @"en_US";
//        langType = @"en_GB";
//        langType = @"fr_FR";
//        langType = @"de_DE";
        
        langType = @"en_US";
        
        /* Nuance can also create a custom recognition type optimized for your application if neither search nor dictation are appropriate. */
        
        NSLog(@"Recognizing type:'%@' Language Code: '%@' using end-of-speech detection:%d.", recoType, langType, detectionType);
		
        voiceSearch = [[SKRecognizer alloc] initWithType:recoType
                                               detection:detectionType
                                                language:langType 
                                                delegate:self];
    }
}

#pragma mark -
#pragma mark TableView methods

- (NSInteger)numberOfSectionsInTableView:(UITableView *)tableView {
    return 1;
}

// Customize the number of rows in the table view.
- (NSInteger)tableView:(UITableView *)tableView numberOfRowsInSection:(NSInteger)section {
    return [histroys count];
}


- (CGFloat)tableView:(UITableView *)tableView heightForRowAtIndexPath:(NSIndexPath *)indexPath {
    NSLog(@"%d",[indexPath row]);
    NSMutableDictionary *aa= [histroys objectAtIndex:[indexPath row]];
    NSLog(@"%@",aa);
	UIView *chatView = [[histroys objectAtIndex:[indexPath row]] objectForKey:@"view"];
	return chatView.frame.size.height+10.0f;
}


// Customize the appearance of table view cells.
- (UITableViewCell *)tableView:(UITableView *)tableView cellForRowAtIndexPath:(NSIndexPath *)indexPath {
    
    static NSString *CellIdentifier = @"Cell";
    
    UITableViewCell *cell = [tableView dequeueReusableCellWithIdentifier:CellIdentifier];
    if (cell == nil) {
        cell = [[UITableViewCell alloc] initWithFrame:CGRectZero reuseIdentifier:CellIdentifier];
        
		cell.backgroundColor = [UIColor colorWithRed:0.859f green:0.886f blue:0.929f alpha:1.0f];
		cell.selectionStyle = UITableViewCellSelectionStyleNone;
    }
    
    // Set up the cell...y
	NSDictionary *chatInfo = [histroys objectAtIndex:[indexPath row]];
	for(UIView *subview in [cell.contentView subviews])
		[subview removeFromSuperview];
	[cell.contentView addSubview:[chatInfo objectForKey:@"view"]];
    return cell;
}

#pragma mark -
#pragma mark SpeechKitDelegate methods

- (void) destroyed {
    // Debug - Uncomment this code and fill in your app ID below, and set
    // the Main Window nib to MainWindow_Debug (in DMRecognizer-Info.plist)
    // if you need the ability to change servers in DMRecognizer
    //
    //[SpeechKit setupWithID:INSERT_YOUR_APPLICATION_ID_HERE
    //                  host:INSERT_YOUR_HOST_ADDRESS_HERE
    //                  port:INSERT_YOUR_HOST_PORT_HERE[[portBox text] intValue]
    //                useSSL:NO];
    //              delegate:self];
    //
	// Set earcons to play
	//SKEarcon* earconStart	= [SKEarcon earconWithName:@"earcon_listening.wav"];
	//SKEarcon* earconStop	= [SKEarcon earconWithName:@"earcon_done_listening.wav"];
	//SKEarcon* earconCancel	= [SKEarcon earconWithName:@"earcon_cancel.wav"];
	//
	//[SpeechKit setEarcon:earconStart forType:SKStartRecordingEarconType];
	//[SpeechKit setEarcon:earconStop forType:SKStopRecordingEarconType];
	//[SpeechKit setEarcon:earconCancel forType:SKCancelRecordingEarconType];    
}

#pragma mark -
#pragma mark SKRecognizerDelegate methods

- (void)recognizerDidBeginRecording:(SKRecognizer *)recognizer
{
    NSLog(@"Recording started.");
    
    transactionState = TS_RECORDING;
    [recordButton setTitle:@"Recording..." forState:UIControlStateNormal];
//    [self performSelector:@selector(updateVUMeter) withObject:nil afterDelay:0.05];
}

- (void)recognizerDidFinishRecording:(SKRecognizer *)recognizer
{
    NSLog(@"Recording finished.");
    
//    [NSObject cancelPreviousPerformRequestsWithTarget:self selector:@selector(updateVUMeter) object:nil];
//    [self setVUMeterWidth:0.];
    transactionState = TS_PROCESSING;
    [recordButton setTitle:@"Recognizing..." forState:UIControlStateNormal];
}

- (void)recognizer:(SKRecognizer *)recognizer didFinishWithResults:(SKRecognition *)results
{
    NSLog(@"Got results.");
    
    long numOfResults = [results.results count];
    
    transactionState = TS_IDLE;
    [recordButton setTitle:@"Recognized..." forState:UIControlStateNormal];
    
    if (numOfResults > 0)
    {
//        searchBox.text = [results firstResult];
        
        // add talk
        [self addTalk:[results firstResult] isSelf:NO];
        
        // search answer
        [self directAnswer:[results firstResult]];
    }
    
//	if (numOfResults > 1) 
//		alternativesDisplay.text = [[results.results subarrayWithRange:NSMakeRange(1, numOfResults-1)] componentsJoinedByString:@"\n"];
    
    if (results.suggestion)
    {
        [recordButton setTitle:@"Record" forState:UIControlStateNormal];
        
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"Suggestion"
                                                        message:results.suggestion
                                                       delegate:nil
                                              cancelButtonTitle:@"OK"
                                              otherButtonTitles:nil];        
        [alert show];
        
    }
    
	voiceSearch = nil;
}

- (void)recognizer:(SKRecognizer *)recognizer didFinishWithError:(NSError *)error suggestion:(NSString *)suggestion
{
    NSLog(@"Got error.");
    
    transactionState = TS_IDLE;
    [recordButton setTitle:@"Record" forState:UIControlStateNormal];
    
    UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"Error"
                                                    message:[error localizedDescription]
                                                   delegate:nil
                                          cancelButtonTitle:@"OK"
                                          otherButtonTitles:nil];
    [alert show];
    
    if (suggestion)
    {
        UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"Suggestion"
                                                        message:suggestion
                                                       delegate:nil
                                              cancelButtonTitle:@"OK"
                                              otherButtonTitles:nil];
        [alert show];
        
    }
    
	voiceSearch = nil;
}

#pragma mark -
#pragma mark SKVocalizerDelegate methods

- (void)vocalizer:(SKVocalizer *)vocalizer willBeginSpeakingString:(NSString *)text {
    isSpeaking = YES;
    [recordButton setTitle:@"Speaking..." forState:UIControlStateNormal];
//    [speakButton setTitle:@"Stop" forState:UIControlStateNormal];
//	if (text)
//		textReadSoFar.text = [[textReadSoFar.text stringByAppendingString:text] stringByAppendingString:@"\n"];
}

- (void)vocalizer:(SKVocalizer *)vocalizer willSpeakTextAtCharacter:(NSUInteger)index ofString:(NSString *)text {
//    textReadSoFar.text = [text substringToIndex:index];
}

- (void)vocalizer:(SKVocalizer *)vocalizer didFinishSpeakingString:(NSString *)text withError:(NSError *)error {
    [recordButton setTitle:@"Record" forState:UIControlStateNormal];
    isSpeaking = NO;
//    [speakButton setTitle:@"Read It" forState:UIControlStateNormal];
	if (error !=nil)
	{
        [recordButton setTitle:@"Record" forState:UIControlStateNormal];
        
		UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"Error"
														message:[error localizedDescription]
													   delegate:nil
											  cancelButtonTitle:@"OK"
											  otherButtonTitles:nil];        
		[alert show];
	}
}

#pragma mark -
#pragma mark Common methods

-(void) directAnswer:(NSString *)vQuestion
{
    [recordButton setTitle:@"Searching..." forState:UIControlStateNormal];
    
	NSString *urlString = [NSString stringWithFormat:@"https://api.trueknowledge.com/direct_answer?object_metadata=image128,wikipedia,official&question=%@&api_account_id=%@&api_password=%@",[Config stringByURLEncodingStringParameter:vQuestion],[Config stringByURLEncodingStringParameter:TrueKnowledgeID],[Config stringByURLEncodingStringParameter:TrueKnowledgePassword]];
    NSURL *url = [[NSURL alloc] initWithString:urlString];
    
    NSXMLParser *xmlParser = [[NSXMLParser alloc] initWithContentsOfURL:url];
    [xmlParser setDelegate:self];
    
    BOOL result = [xmlParser parse];
    if (!result)
    {
        [recordButton setTitle:@"Record" forState:UIControlStateNormal];
        
		UIAlertView *alert = [[UIAlertView alloc] initWithTitle:@"Error"
														message:[xmlParser parserError]
													   delegate:nil
											  cancelButtonTitle:@"OK"
											  otherButtonTitles:nil];        
		[alert show];
    }
}

-(void) speakString:(NSString *)vString
{
    [recordButton setTitle:@"Speaking..." forState:UIControlStateNormal];
    
    // Initializes an english voice
    vocalizer = [[SKVocalizer alloc] initWithLanguage:@"en_US" delegate:self];
    
    // Speaks the string text
    [vocalizer speakString:vString];
}

-(void) addTalk:(NSString *)vText isSelf:(BOOL)vIsSelf
{
    // histroy data
    UIView *bubbleView = [self bubbleView:vText from:vIsSelf];
    NSMutableDictionary *talk=[NSMutableDictionary dictionary];
    [talk setObject:vIsSelf?@"self":@"other" forKey:@"speaker"];
    [talk setObject:vText forKey:@"text"];
    [talk setObject:bubbleView forKey:@"view"];
    [histroys addObject:talk];
    
    // history ui
    [histroyTableView reloadData];
	[histroyTableView scrollToRowAtIndexPath:[NSIndexPath indexPathForRow:[histroys count]-1 inSection:0] atScrollPosition:UITableViewScrollPositionBottom animated:NO];
}

- (UIView *)bubbleView:(NSString *)text from:(BOOL)fromSelf
{
	// build single chat bubble cell with given text
	UIView *returnView = [[UIView alloc] initWithFrame:CGRectZero];
	returnView.backgroundColor = [UIColor clearColor];
    
	UIImage *bubble = [UIImage imageWithContentsOfFile:[[NSBundle mainBundle] pathForResource:fromSelf?@"bubbleSelf":@"bubble" ofType:@"png"]];
	UIImageView *bubbleImageView = [[UIImageView alloc] initWithImage:[bubble stretchableImageWithLeftCapWidth:21 topCapHeight:14]];
    
	UIFont *font = [UIFont systemFontOfSize:12];
	CGSize size = [text sizeWithFont:font constrainedToSize:CGSizeMake(150.0f, 1000.0f) lineBreakMode:UILineBreakModeCharacterWrap];
    
	UILabel *bubbleText = [[UILabel alloc] initWithFrame:CGRectMake(21.0f, 14.0f, size.width+10, size.height+10)];
	bubbleText.backgroundColor = [UIColor clearColor];
	bubbleText.font = font;
	bubbleText.numberOfLines = 0;
	bubbleText.lineBreakMode = UILineBreakModeCharacterWrap;
	bubbleText.text = text;
	
	bubbleImageView.frame = CGRectMake(0.0f, 0.0f, 200.0f, size.height+40.0f);
	if(fromSelf)
		returnView.frame = CGRectMake(120.0f, 10.0f, 200.0f, size.height+50.0f);
	else
		returnView.frame = CGRectMake(0.0f, 10.0f, 200.0f, size.height+50.0f);
	
	[returnView addSubview:bubbleImageView];
	[returnView addSubview:bubbleText];
    
	return returnView;
}


#pragma mark -
#pragma mark NSXMLParserDelegate

- (void)parser:(NSXMLParser *)parser didStartElement:(NSString *)elementName namespaceURI:(NSString *)namespaceURI qualifiedName:(NSString *)qName attributes:(NSDictionary *)attributeDict
{
    currentElementName=elementName;
}

- (void)parser:(NSXMLParser *)parser foundCharacters:(NSString *)string
{
    if (([currentElementName isEqualToString:@"tk:text_result"])||([currentElementName isEqualToString:@"tk:error_message"]))
    {
        // stop parsing
        [parser abortParsing];
        
        // add talk
        [self addTalk:string isSelf:YES];
        
        // speak string
        [self speakString:string];
    }
}

- (void)parser:(NSXMLParser *)parser didEndElement:(NSString *)elementName namespaceURI:(NSString *)namespaceURI qualifiedName:(NSString *)qName
{
    currentElementName=nil;
}

@end
